// mergeSort.java
// Program demonstruje rekurencyjne sortowanie przez scalanie
// Aby uruchomi program: C>java MergeSortApp
////////////////////////////////////////////////////////////////
class DArray
   {
   private long[] theArray;          // odwoanie do tablicy theArray
   private int nElems;               // ilo elementw
   //-----------------------------------------------------------
   public DArray(int max)            // konstruktor
      {
      theArray = new long[max];      // stworzenie tablicy
      nElems = 0;
      }
   //-----------------------------------------------------------
   public void insert(long value)    // zapisanie elementu w tablicy
      {
      theArray[nElems] = value;      // wstawiamy element
      nElems++;                      // inkrementujemy ilo elementw
      }
   //-----------------------------------------------------------
   public void display()             // wywietlenie zawartoci tablicy
      {
      for(int j=0; j<nElems; j++)    // dla kadego elementu,
         System.out.print(theArray[j] + " ");  // wywietlamy go
      System.out.println("");
      }
   //-----------------------------------------------------------
   public void mergeSort()           // wywoywana przez main()
      {                              // tworzymy obszar roboczy
      long[] workSpace = new long[nElems];
      recMergeSort(workSpace, 0, nElems-1);
      }
   //-----------------------------------------------------------
   private void recMergeSort(long[] workSpace, int lowerBound,
                                               int upperBound)
      {
      if(lowerBound == upperBound)            // jeli zakres zawiera 1 elem.,
         return;                              // nie ma sensu sortowa
      else
         {                                    // znajdujemy punkt rodkowy
         int mid = (lowerBound+upperBound) / 2;
                                              // sortujemy lew powk
         recMergeSort(workSpace, lowerBound, mid);
                                              // sortujemy praw powk
         recMergeSort(workSpace, mid+1, upperBound);
                                              // scalamy posortowane powki
         merge(workSpace, lowerBound, mid+1, upperBound);
         }  // koniec klauzuli else
      }  // koniec metody recMergeSort()
   //-----------------------------------------------------------
   private void merge(long[] workSpace, int lowPtr,
                           int highPtr, int upperBound)
      {
      int j = 0;                             // indeks obszaru roboczego
      int lowerBound = lowPtr;
      int mid = highPtr-1;
      int n = upperBound-lowerBound+1;       // ilo elementw

      while(lowPtr <= mid && highPtr <= upperBound)
         if( theArray[lowPtr] < theArray[highPtr] )
            workSpace[j++] = theArray[lowPtr++];
         else
            workSpace[j++] = theArray[highPtr++];

      while(lowPtr <= mid)
         workSpace[j++] = theArray[lowPtr++];

      while(highPtr <= upperBound)
         workSpace[j++] = theArray[highPtr++];

      for(j=0; j<n; j++)
         theArray[lowerBound+j] = workSpace[j];
      }  // koniec metody merge()
   //-----------------------------------------------------------
   }  // koniec class DArray
////////////////////////////////////////////////////////////////
class MergeSortApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;             // wielko tablicy
      DArray arr;                    // odwoanie do tablicy
      arr = new DArray(maxSize);     // tworzymy tablic

      arr.insert(64);                // wstawiamy elementy
      arr.insert(21);
      arr.insert(33);
      arr.insert(70);
      arr.insert(12);
      arr.insert(85);
      arr.insert(44);
      arr.insert(3);
      arr.insert(99);
      arr.insert(0);
      arr.insert(108);
      arr.insert(36);

      arr.display();                 // wywietamy elementy

      arr.mergeSort();               // sortujemy tablic

      arr.display();                 // ponownie wywietlamy elementy
      }  // koniec metody main()
   }  // koniec class MergeSortApp
////////////////////////////////////////////////////////////////
